library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.SHA256_PACKAGE.all;

entity S2_BLOCK is
	port( X : in std_logic_vector(31 downto 0);
		  O : out std_logic_vector(31 downto 0));
end S2_BLOCK;

architecture BEHAVIORAL of S2_BLOCK is

	signal ROR2 : std_logic_vector(31 downto 0);
	signal ROR13 : std_logic_vector(31 downto 0);
	signal ROR22 : std_logic_vector(31 downto 0);

begin

	ROR2 <= X(1 downto 0) & X(31 downto 2);
	ROR13 <= X(12 downto 0) & X(31 downto 13);
	ROR22 <= X(21 downto 0) & X(31 downto 22);

	O <= ROR2 xor ROR13 xor ROR22;

end BEHAVIORAL;